/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.blocks.industrial_fan.Processing;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.kinetics.fan.processing.HauntingRecipe;
import com.simibubi.create.content.kinetics.fan.processing.SplashingRecipe;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.burner.LitBlazeBurnerBlock;
import com.simibubi.create.content.trains.CubeParticleData;
import com.simibubi.create.foundation.damageTypes.CreateDamageSources;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerContainer;
import io.github.fabricators_of_create.porting_lib.transfer.item.RecipeWrapper;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1473;
import net.minecraft.class_1498;
import net.minecraft.class_1506;
import net.minecraft.class_1545;
import net.minecraft.class_1560;
import net.minecraft.class_1613;
import net.minecraft.class_1627;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_3862;
import net.minecraft.class_3922;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import uwu.lopyluna.create_dd.DDCreate;
import uwu.lopyluna.create_dd.blocks.industrial_fan.Processing.DDFanProcessingTypeRegistry;
import uwu.lopyluna.create_dd.blocks.industrial_fan.Processing.IndustrialProcessingType;
import uwu.lopyluna.create_dd.recipe.Recipes.FreezingRecipe;
import uwu.lopyluna.create_dd.recipe.Recipes.SuperheatingRecipe;
import uwu.lopyluna.create_dd.registry.DDRecipesTypes;
import uwu.lopyluna.create_dd.registry.DDTags;

public class IndustrialTypeFanProcessing {
    public static final NoneType NONE = IndustrialTypeFanProcessing.register("none", new NoneType());
    public static final BlastingType BLASTING = IndustrialTypeFanProcessing.register("blasting", new BlastingType());
    public static final HauntingType HAUNTING = IndustrialTypeFanProcessing.register("haunting", new HauntingType());
    public static final SmokingType SMOKING = IndustrialTypeFanProcessing.register("smoking", new SmokingType());
    public static final SplashingType SPLASHING = IndustrialTypeFanProcessing.register("splashing", new SplashingType());
    public static final FreezingType FREEZING = IndustrialTypeFanProcessing.register("freezing", new FreezingType());
    public static final SuperheatingType SUPERHEATING = IndustrialTypeFanProcessing.register("superheating", new SuperheatingType());
    private static final Map<String, IndustrialProcessingType> LEGACY_NAME_MAP;

    private static <T extends IndustrialProcessingType> T register(String id, T type) {
        DDFanProcessingTypeRegistry.register(DDCreate.asResource(id), type);
        return type;
    }

    @Nullable
    public static IndustrialProcessingType ofLegacyName(String name) {
        return LEGACY_NAME_MAP.get(name);
    }

    public static IndustrialProcessingType parseLegacy(String str) {
        IndustrialProcessingType type = IndustrialTypeFanProcessing.ofLegacyName(str);
        if (type != null) {
            return type;
        }
        return IndustrialProcessingType.parse(str);
    }

    public static void register() {
    }

    static {
        Object2ReferenceOpenHashMap map = new Object2ReferenceOpenHashMap();
        map.put((Object)"NONE", (Object)NONE);
        map.put((Object)"BLASTING", (Object)BLASTING);
        map.put((Object)"HAUNTING", (Object)HAUNTING);
        map.put((Object)"SMOKING", (Object)SMOKING);
        map.put((Object)"SPLASHING", (Object)SPLASHING);
        map.put((Object)"FREEZING", (Object)FREEZING);
        map.put((Object)"SUPERHEATING", (Object)SUPERHEATING);
        map.trim();
        LEGACY_NAME_MAP = map;
    }

    public static class NoneType
    implements IndustrialProcessingType {
        @Override
        public boolean isValidAt(class_1937 level, class_2338 pos) {
            return true;
        }

        @Override
        public int getPriority() {
            return -1000000;
        }

        @Override
        public boolean canProcess(class_1799 stack, class_1937 level) {
            return false;
        }

        @Override
        @Nullable
        public List<class_1799> process(class_1799 stack, class_1937 level) {
            return null;
        }

        @Override
        public void spawnProcessingParticles(class_1937 level, class_243 pos) {
        }

        @Override
        public void morphAirFlow(IndustrialProcessingType.DDAirFlowParticleAccess particleAccess, class_5819 random) {
        }

        @Override
        public void affectEntity(class_1297 entity, class_1937 level) {
        }
    }

    public static class BlastingType
    implements IndustrialProcessingType {
        private static final RecipeWrapper RECIPE_WRAPPER = new RecipeWrapper(new ItemStackHandler(1));

        @Override
        public boolean isValidAt(class_1937 level, class_2338 pos) {
            class_3610 fluidState = level.method_8316(pos);
            if (AllTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_BLASTING.matches(fluidState)) {
                return true;
            }
            class_2680 blockState = level.method_8320(pos);
            if (AllTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_BLASTING.matches(blockState)) {
                return !blockState.method_28498((class_2769)BlazeBurnerBlock.HEAT_LEVEL) || ((BlazeBurnerBlock.HeatLevel)blockState.method_11654((class_2769)BlazeBurnerBlock.HEAT_LEVEL)).isAtLeast(BlazeBurnerBlock.HeatLevel.FADING);
            }
            return false;
        }

        @Override
        public int getPriority() {
            return 100;
        }

        @Override
        public boolean canProcess(class_1799 stack, class_1937 level) {
            RECIPE_WRAPPER.method_5447(0, stack);
            Optional smeltingRecipe = level.method_8433().method_8132(class_3956.field_17546, (class_1263)RECIPE_WRAPPER, level);
            if (smeltingRecipe.isPresent()) {
                return true;
            }
            RECIPE_WRAPPER.method_5447(0, stack);
            Optional blastingRecipe = level.method_8433().method_8132(class_3956.field_17547, (class_1263)RECIPE_WRAPPER, level);
            if (blastingRecipe.isPresent()) {
                return true;
            }
            return !stack.method_7909().method_24358();
        }

        @Override
        @Nullable
        public List<class_1799> process(class_1799 stack, class_1937 level) {
            RECIPE_WRAPPER.method_5447(0, stack);
            Optional smokingRecipe = level.method_8433().method_8132(class_3956.field_17548, (class_1263)RECIPE_WRAPPER, level);
            RECIPE_WRAPPER.method_5447(0, stack);
            Optional smeltingRecipe = level.method_8433().method_8132(class_3956.field_17546, (class_1263)RECIPE_WRAPPER, level);
            if (!smeltingRecipe.isPresent()) {
                RECIPE_WRAPPER.method_5447(0, stack);
                smeltingRecipe = level.method_8433().method_8132(class_3956.field_17547, (class_1263)RECIPE_WRAPPER, level);
            }
            if (smeltingRecipe.isPresent()) {
                class_5455 registryAccess = level.method_30349();
                if (!smokingRecipe.isPresent() || !class_1799.method_7984((class_1799)((class_3862)smokingRecipe.get()).method_8110(registryAccess), (class_1799)((class_1874)smeltingRecipe.get()).method_8110(registryAccess))) {
                    return RecipeApplier.applyRecipeOn((class_1937)level, (class_1799)stack, (class_1860)((class_1860)smeltingRecipe.get()));
                }
            }
            return Collections.emptyList();
        }

        @Override
        public void spawnProcessingParticles(class_1937 level, class_243 pos) {
            if (level.field_9229.method_43048(8) != 0) {
                return;
            }
            level.method_8406((class_2394)class_2398.field_11237, pos.field_1352, pos.field_1351 + 0.25, pos.field_1350, 0.0, 0.0625, 0.0);
        }

        @Override
        public void morphAirFlow(IndustrialProcessingType.DDAirFlowParticleAccess particleAccess, class_5819 random) {
            particleAccess.setColor(Color.mixColors((int)0xFF4400, (int)0xFF8855, (float)random.method_43057()));
            particleAccess.setAlpha(0.5f);
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_11240, 0.25f);
            }
            if (random.method_43057() < 0.0625f) {
                particleAccess.spawnExtraParticle((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10164.method_9564()), 0.25f);
            }
        }

        @Override
        public void affectEntity(class_1297 entity, class_1937 level) {
            if (level.field_9236) {
                return;
            }
            if (!entity.method_5753()) {
                entity.method_5639(10);
                entity.method_5643(CreateDamageSources.fanLava((class_1937)level), 4.0f);
            }
        }
    }

    public static class HauntingType
    implements IndustrialProcessingType {
        private static final HauntingRecipe.HauntingWrapper HAUNTING_WRAPPER = new HauntingRecipe.HauntingWrapper();

        @Override
        public boolean isValidAt(class_1937 level, class_2338 pos) {
            class_3610 fluidState = level.method_8316(pos);
            if (AllTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_HAUNTING.matches(fluidState)) {
                return true;
            }
            class_2680 blockState = level.method_8320(pos);
            if (AllTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_HAUNTING.matches(blockState)) {
                if (blockState.method_26164(class_3481.field_23799) && blockState.method_28498((class_2769)class_3922.field_17352) && !((Boolean)blockState.method_11654((class_2769)class_3922.field_17352)).booleanValue()) {
                    return false;
                }
                return !blockState.method_28498((class_2769)LitBlazeBurnerBlock.FLAME_TYPE) || blockState.method_11654((class_2769)LitBlazeBurnerBlock.FLAME_TYPE) == LitBlazeBurnerBlock.FlameType.SOUL;
            }
            return false;
        }

        @Override
        public int getPriority() {
            return 300;
        }

        @Override
        public boolean canProcess(class_1799 stack, class_1937 level) {
            HAUNTING_WRAPPER.method_5447(0, stack);
            Optional recipe = AllRecipeTypes.HAUNTING.find((class_1263)HAUNTING_WRAPPER, level);
            return recipe.isPresent();
        }

        @Override
        @Nullable
        public List<class_1799> process(class_1799 stack, class_1937 level) {
            HAUNTING_WRAPPER.method_5447(0, stack);
            Optional recipe = AllRecipeTypes.HAUNTING.find((class_1263)HAUNTING_WRAPPER, level);
            if (recipe.isPresent()) {
                return RecipeApplier.applyRecipeOn((class_1937)level, (class_1799)stack, (class_1860)((class_1860)recipe.get()));
            }
            return null;
        }

        @Override
        public void spawnProcessingParticles(class_1937 level, class_243 pos) {
            if (level.field_9229.method_43048(8) != 0) {
                return;
            }
            pos = pos.method_1019(VecHelper.offsetRandomly((class_243)class_243.field_1353, (class_5819)level.field_9229, (float)1.0f).method_18805(1.0, (double)0.05f, 1.0).method_1029().method_1021((double)0.15f));
            level.method_8406((class_2394)class_2398.field_22246, pos.field_1352, pos.field_1351 + (double)0.45f, pos.field_1350, 0.0, 0.0, 0.0);
            if (level.field_9229.method_43048(2) == 0) {
                level.method_8406((class_2394)class_2398.field_11251, pos.field_1352, pos.field_1351 + 0.25, pos.field_1350, 0.0, 0.0, 0.0);
            }
        }

        @Override
        public void morphAirFlow(IndustrialProcessingType.DDAirFlowParticleAccess particleAccess, class_5819 random) {
            particleAccess.setColor(Color.mixColors((int)0, (int)1205608, (float)random.method_43057()));
            particleAccess.setAlpha(1.0f);
            if (random.method_43057() < 0.0078125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_22246, 0.125f);
            }
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_11251, 0.125f);
            }
        }

        @Override
        public void affectEntity(class_1297 entity, class_1937 level) {
            if (level.field_9236) {
                if (entity instanceof class_1498) {
                    class_243 p = entity.method_30950(0.0f);
                    class_243 v = p.method_1031(0.0, 0.5, 0.0).method_1019(VecHelper.offsetRandomly((class_243)class_243.field_1353, (class_5819)level.field_9229, (float)1.0f).method_18805(1.0, (double)0.2f, 1.0).method_1029().method_1021(1.0));
                    level.method_8406((class_2394)class_2398.field_22246, v.field_1352, v.field_1351, v.field_1350, 0.0, (double)0.1f, 0.0);
                    if (level.field_9229.method_43048(3) == 0) {
                        level.method_8406((class_2394)class_2398.field_11237, p.field_1352, p.field_1351 + 0.5, p.field_1350, (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), (double)0.1f, (double)((level.field_9229.method_43057() - 0.5f) * 0.5f));
                    }
                }
                return;
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                livingEntity.method_6092(new class_1293(class_1294.field_5919, 30, 0, false, false));
                livingEntity.method_6092(new class_1293(class_1294.field_5909, 20, 1, false, false));
            }
            if (entity instanceof class_1498) {
                class_1498 horse = (class_1498)entity;
                int progress = horse.getCustomData().method_10550("CreateHaunting");
                if (progress < 100) {
                    if (progress % 10 == 0) {
                        level.method_8396(null, entity.method_24515(), class_3417.field_23060, class_3419.field_15254, 1.0f, 1.5f * (float)progress / 100.0f);
                    }
                    horse.getCustomData().method_10569("CreateHaunting", progress + 1);
                    return;
                }
                level.method_8396(null, entity.method_24515(), class_3417.field_15222, class_3419.field_15254, 1.25f, 0.65f);
                class_1506 skeletonHorse = (class_1506)class_1299.field_6075.method_5883(level);
                class_2487 serializeNBT = horse.method_5647(new class_2487());
                serializeNBT.method_10551("UUID");
                if (!horse.method_6786().method_7960()) {
                    horse.method_5775(horse.method_6786());
                }
                skeletonHorse.deserializeNBT((class_2520)serializeNBT);
                skeletonHorse.method_33574(horse.method_30950(0.0f));
                level.method_8649((class_1297)skeletonHorse);
                horse.method_31472();
            }
        }
    }

    public static class SmokingType
    implements IndustrialProcessingType {
        private static final ItemStackHandlerContainer RECIPE_WRAPPER = new ItemStackHandlerContainer();

        @Override
        public boolean isValidAt(class_1937 level, class_2338 pos) {
            class_3610 fluidState = level.method_8316(pos);
            if (AllTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_SMOKING.matches(fluidState)) {
                return true;
            }
            class_2680 blockState = level.method_8320(pos);
            if (AllTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_SMOKING.matches(blockState)) {
                if (blockState.method_26164(class_3481.field_23799) && blockState.method_28498((class_2769)class_3922.field_17352) && !((Boolean)blockState.method_11654((class_2769)class_3922.field_17352)).booleanValue()) {
                    return false;
                }
                if (blockState.method_28498((class_2769)LitBlazeBurnerBlock.FLAME_TYPE) && blockState.method_11654((class_2769)LitBlazeBurnerBlock.FLAME_TYPE) != LitBlazeBurnerBlock.FlameType.REGULAR) {
                    return false;
                }
                return !blockState.method_28498((class_2769)BlazeBurnerBlock.HEAT_LEVEL) || blockState.method_11654((class_2769)BlazeBurnerBlock.HEAT_LEVEL) == BlazeBurnerBlock.HeatLevel.SMOULDERING;
            }
            return false;
        }

        @Override
        public int getPriority() {
            return 200;
        }

        @Override
        public boolean canProcess(class_1799 stack, class_1937 level) {
            RECIPE_WRAPPER.method_5447(0, stack);
            Optional recipe = level.method_8433().method_8132(class_3956.field_17548, (class_1263)RECIPE_WRAPPER, level);
            return recipe.isPresent();
        }

        @Override
        @Nullable
        public List<class_1799> process(class_1799 stack, class_1937 level) {
            RECIPE_WRAPPER.method_5447(0, stack);
            Optional smokingRecipe = level.method_8433().method_8132(class_3956.field_17548, (class_1263)RECIPE_WRAPPER, level);
            if (smokingRecipe.isPresent()) {
                return RecipeApplier.applyRecipeOn((class_1937)level, (class_1799)stack, (class_1860)((class_1860)smokingRecipe.get()));
            }
            return null;
        }

        @Override
        public void spawnProcessingParticles(class_1937 level, class_243 pos) {
            if (level.field_9229.method_43048(8) != 0) {
                return;
            }
            level.method_8406((class_2394)class_2398.field_11203, pos.field_1352, pos.field_1351 + 0.25, pos.field_1350, 0.0, 0.0625, 0.0);
        }

        @Override
        public void morphAirFlow(IndustrialProcessingType.DDAirFlowParticleAccess particleAccess, class_5819 random) {
            particleAccess.setColor(Color.mixColors((int)0, (int)0x555555, (float)random.method_43057()));
            particleAccess.setAlpha(1.0f);
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_11251, 0.125f);
            }
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_11237, 0.125f);
            }
        }

        @Override
        public void affectEntity(class_1297 entity, class_1937 level) {
            if (level.field_9236) {
                return;
            }
            if (!entity.method_5753()) {
                entity.method_5639(2);
                entity.method_5643(CreateDamageSources.fanFire((class_1937)level), 2.0f);
            }
        }
    }

    public static class SplashingType
    implements IndustrialProcessingType {
        private static final SplashingRecipe.SplashingWrapper SPLASHING_WRAPPER = new SplashingRecipe.SplashingWrapper();

        @Override
        public boolean isValidAt(class_1937 level, class_2338 pos) {
            class_3610 fluidState = level.method_8316(pos);
            if (AllTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_SPLASHING.matches(fluidState)) {
                return true;
            }
            class_2680 blockState = level.method_8320(pos);
            return AllTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_SPLASHING.matches(blockState);
        }

        @Override
        public int getPriority() {
            return 400;
        }

        @Override
        public boolean canProcess(class_1799 stack, class_1937 level) {
            SPLASHING_WRAPPER.method_5447(0, stack);
            Optional recipe = AllRecipeTypes.SPLASHING.find((class_1263)SPLASHING_WRAPPER, level);
            return recipe.isPresent();
        }

        @Override
        @Nullable
        public List<class_1799> process(class_1799 stack, class_1937 level) {
            SPLASHING_WRAPPER.method_5447(0, stack);
            Optional recipe = AllRecipeTypes.SPLASHING.find((class_1263)SPLASHING_WRAPPER, level);
            if (recipe.isPresent()) {
                return RecipeApplier.applyRecipeOn((class_1937)level, (class_1799)stack, (class_1860)((class_1860)recipe.get()));
            }
            return null;
        }

        @Override
        public void spawnProcessingParticles(class_1937 level, class_243 pos) {
            if (level.field_9229.method_43048(8) != 0) {
                return;
            }
            Vector3f color = new Color(22015).asVectorF();
            level.method_8406((class_2394)new class_2390(color, 1.0f), pos.field_1352 + (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), pos.field_1351 + 0.5, pos.field_1350 + (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.method_8406((class_2394)class_2398.field_11228, pos.field_1352 + (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), pos.field_1351 + 0.5, pos.field_1350 + (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        @Override
        public void morphAirFlow(IndustrialProcessingType.DDAirFlowParticleAccess particleAccess, class_5819 random) {
            particleAccess.setColor(Color.mixColors((int)0x4499FF, (int)0x2277FF, (float)random.method_43057()));
            particleAccess.setAlpha(1.0f);
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_11247, 0.125f);
            }
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_11241, 0.125f);
            }
        }

        @Override
        public void affectEntity(class_1297 entity, class_1937 level) {
            if (level.field_9236) {
                return;
            }
            if (entity instanceof class_1560 || entity.method_5864() == class_1299.field_6047 || entity.method_5864() == class_1299.field_6099) {
                entity.method_5643(entity.method_48923().method_48824(), 2.0f);
            }
            if (entity.method_5809()) {
                entity.method_5646();
                level.method_8396(null, entity.method_24515(), class_3417.field_15222, class_3419.field_15254, 0.7f, 1.6f + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.4f);
            }
        }
    }

    public static class FreezingType
    implements IndustrialProcessingType {
        private static final FreezingRecipe.FreezingWrapper FREEZING_WRAPPER = new FreezingRecipe.FreezingWrapper();

        @Override
        public boolean isValidAt(class_1937 level, class_2338 pos) {
            class_3610 fluidState = level.method_8316(pos);
            if (DDTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_FREEZING.matches(fluidState)) {
                return true;
            }
            class_2680 blockState = level.method_8320(pos);
            return DDTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_FREEZING.matches(blockState);
        }

        @Override
        public int getPriority() {
            return 600;
        }

        @Override
        public boolean canProcess(class_1799 stack, class_1937 level) {
            FREEZING_WRAPPER.method_5447(0, stack);
            Optional recipe = DDRecipesTypes.FREEZING.find(FREEZING_WRAPPER, level);
            return recipe.isPresent();
        }

        @Override
        @Nullable
        public List<class_1799> process(class_1799 stack, class_1937 level) {
            FREEZING_WRAPPER.method_5447(0, stack);
            Optional recipe = DDRecipesTypes.FREEZING.find(FREEZING_WRAPPER, level);
            if (recipe.isPresent()) {
                return RecipeApplier.applyRecipeOn((class_1937)level, (class_1799)stack, (class_1860)((class_1860)recipe.get()));
            }
            return null;
        }

        @Override
        public void spawnProcessingParticles(class_1937 level, class_243 pos) {
            if (level.field_9229.method_43048(8) != 0) {
                return;
            }
            Vector3f color = new Color(14543103).asVectorF();
            level.method_8406((class_2394)new class_2390(color, 1.0f), pos.field_1352 + (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), pos.field_1351 + 0.5, pos.field_1350 + (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.method_8406((class_2394)class_2398.field_28013, pos.field_1352 + (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), pos.field_1351 + 0.5, pos.field_1350 + (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        @Override
        public void morphAirFlow(IndustrialProcessingType.DDAirFlowParticleAccess particleAccess, class_5819 random) {
            particleAccess.setColor(Color.mixColors((int)0xEEEEFF, (int)14543103, (float)random.method_43057()));
            particleAccess.setAlpha(1.0f);
            if (random.method_43057() < 0.0078125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_28013, 0.125f);
            }
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_11203, 0.125f);
            }
        }

        @Override
        public void affectEntity(class_1297 entity, class_1937 level) {
            if (level.field_9236) {
                if (entity instanceof class_1613) {
                    class_243 p = entity.method_30950(0.0f);
                    class_243 v = p.method_1031(0.0, 0.5, 0.0).method_1019(VecHelper.offsetRandomly((class_243)class_243.field_1353, (class_5819)level.field_9229, (float)1.0f).method_18805(1.0, (double)0.2f, 1.0).method_1029().method_1021(1.0));
                    level.method_8406((class_2394)class_2398.field_28013, v.field_1352, v.field_1351, v.field_1350, 0.0, (double)0.1f, 0.0);
                    if (level.field_9229.method_43048(3) == 0) {
                        level.method_8406((class_2394)class_2398.field_28013, p.field_1352, p.field_1351 + 0.5, p.field_1350, (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), (double)0.1f, (double)((level.field_9229.method_43057() - 0.5f) * 0.5f));
                    }
                }
                return;
            }
            if (entity instanceof class_1560 || entity.method_5864() == class_1299.field_6099) {
                entity.method_5643(entity.method_48923().method_48836(), 8.0f);
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                livingEntity.method_6092(new class_1293(class_1294.field_5909, 20, 7, false, false));
            }
            if (entity instanceof class_1473) {
                class_1473 snowgolem = (class_1473)entity;
                snowgolem.method_6025(4.0f);
            }
            if (entity instanceof class_1627) {
                class_1627 stray = (class_1627)entity;
                stray.method_6025(2.0f);
            }
            if (entity.method_5809()) {
                entity.method_5646();
                level.method_8396(null, entity.method_24515(), class_3417.field_15222, class_3419.field_15254, 0.7f, 1.6f + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.4f);
            }
            if (entity instanceof class_1613) {
                class_1613 skeleton = (class_1613)entity;
                int progress = skeleton.getCustomData().method_10550("CreateFreezing");
                if (progress < 50) {
                    if (progress % 10 == 0) {
                        level.method_8396(null, entity.method_24515(), class_3417.field_15041, class_3419.field_15254, 1.0f, 1.5f * (float)progress / 50.0f);
                    }
                    skeleton.getCustomData().method_10569("CreateFreezing", progress + 1);
                    return;
                }
                level.method_8396(null, entity.method_24515(), class_3417.field_28606, class_3419.field_15254, 1.25f, 0.65f);
                class_1627 stray = (class_1627)class_1299.field_6098.method_5883(level);
                class_2487 serializeNBT = skeleton.method_5647(new class_2487());
                serializeNBT.method_10551("UUID");
                assert (stray != null);
                stray.deserializeNBT((class_2520)serializeNBT);
                stray.method_33574(skeleton.method_30950(0.0f));
                level.method_8649((class_1297)stray);
                skeleton.method_31472();
            }
        }
    }

    public static class SuperheatingType
    implements IndustrialProcessingType {
        private static final SuperheatingRecipe.SuperheatingWrapper SUPERHEATING_WRAPPER = new SuperheatingRecipe.SuperheatingWrapper();

        @Override
        public boolean isValidAt(class_1937 level, class_2338 pos) {
            class_3610 fluidState = level.method_8316(pos);
            if (DDTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_SUPERHEATING.matches(fluidState)) {
                return true;
            }
            class_2680 blockState = level.method_8320(pos);
            if (DDTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_SUPERHEATING.matches(blockState)) {
                return !blockState.method_28498((class_2769)BlazeBurnerBlock.HEAT_LEVEL) || ((BlazeBurnerBlock.HeatLevel)blockState.method_11654((class_2769)BlazeBurnerBlock.HEAT_LEVEL)).isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING);
            }
            return false;
        }

        @Override
        public int getPriority() {
            return 500;
        }

        @Override
        public boolean canProcess(class_1799 stack, class_1937 level) {
            SUPERHEATING_WRAPPER.method_5447(0, stack);
            Optional recipe = DDRecipesTypes.SUPERHEATING.find(SUPERHEATING_WRAPPER, level);
            return recipe.isPresent();
        }

        @Override
        @Nullable
        public List<class_1799> process(class_1799 stack, class_1937 level) {
            SUPERHEATING_WRAPPER.method_5447(0, stack);
            Optional<SuperheatingRecipe> recipe = DDRecipesTypes.SUPERHEATING.find(SUPERHEATING_WRAPPER, level);
            return recipe.map(superheatingRecipe -> RecipeApplier.applyRecipeOn((class_1937)level, (class_1799)stack, (class_1860)superheatingRecipe)).orElse(null);
        }

        @Override
        public void spawnProcessingParticles(class_1937 level, class_243 pos) {
            if (level.field_9229.method_43048(8) != 0) {
                return;
            }
            Vector3f color = new Color(1969981).asVectorF();
            level.method_8406((class_2394)new class_2390(color, 1.0f), pos.field_1352 + (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), pos.field_1351 + 0.5, pos.field_1350 + (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.method_8406((class_2394)class_2398.field_22246, pos.field_1352, pos.field_1351 + (double)0.45f, pos.field_1350, 0.0, 0.0, 0.0);
            level.method_8406((class_2394)class_2398.field_22246, pos.field_1352 + (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), pos.field_1351 + 0.5, pos.field_1350 + (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        @Override
        public void morphAirFlow(IndustrialProcessingType.DDAirFlowParticleAccess particleAccess, class_5819 random) {
            particleAccess.setColor(Color.mixColors((int)6605309, (int)4158696, (float)random.method_43057()));
            particleAccess.setAlpha(1.0f);
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_22246, 0.125f);
            }
            Vector3f colorBright = new Color(6605309).asVectorF();
            Vector3f colorDark = new Color(4158696).asVectorF();
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)new class_2390(colorBright, 1.0f), 0.125f);
            }
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)new class_2390(colorDark, 1.0f), 0.125f);
            }
            if (random.method_43057() < 0.020833334f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_11251, 0.125f);
            }
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)new CubeParticleData(192.0f, 122.0f, 85.0f, 0.075f, 10, true), 0.125f);
            }
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)new CubeParticleData(191.0f, 82.0f, 91.0f, 0.1f, 10, true), 0.125f);
            }
        }

        @Override
        public void affectEntity(class_1297 entity, class_1937 level) {
            if (level.field_9236) {
                return;
            }
            if (entity instanceof class_1545) {
                class_1545 blaze = (class_1545)entity;
                blaze.method_6025(4.0f);
            }
            if (!entity.method_5753()) {
                entity.method_5639(10);
                entity.method_5643(CreateDamageSources.fanLava((class_1937)level), 10.0f);
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                livingEntity.method_6092(new class_1293(class_1294.field_5909, 40, 2, false, false));
                livingEntity.method_6092(new class_1293(class_1294.field_5911, 20, 1, false, false));
                livingEntity.method_6092(new class_1293(class_1294.field_5919, 30, 0, false, false));
            }
        }
    }
}

